%This script is planning for the synthetic data generation code, it is a
%collection of functions that need to be implemented

%Each function must apply the same augmentation to both images from the
%pair (to keep pixel wise alignment) except for alignmentAugment. 

%All functions should maintain the image aspect ratios and real size (no
%zooming, resizing). Blank space should be white filled.

clearvars
close all

I1file = '../../ExampleData/A3A11_0008A.jpg';
A1file = '../../ExampleData/A3A11_0008A.txt';
I2file = '../../ExampleData/A3A11_0008B.jpg';
A2file = '../../ExampleData/A3A11_0008B.txt';

I1 = imread(I1file);
A1 = readAnnot(A1file); 
I2 = imread(I2file);
A2 = readAnnot(A2file);


% %Data Generation:
% Isynth = formatBaseImg(imageSource); %Take in a satellite image file, split it 
% % into appropriate sized patches and format these correctly
% 
% [Isynth1,Isynth2] = splitBaseImg(Isynth); %Split the base pair into a matched pair of 
% % images, using augmentations
% 
% cows1 = createCows(); %Create cow appearances (from database or algorithmically)
% cows2 = createCows(); 
% 
% [Isynth1,Asynth1] = addCows(Isynth1, cows1); %Add cows to the image in random locations
% [Isynth2,Asynth2] = addCows(Isynth2, cows2); %Add cows to the image in random locations
% 
% [Isynth1,Isynth2,Asynth1,Asynth2] = augmentImgs(Isynth1,Isynth2,Asynth1,Asynth2); %Apply more 
% % pair wise augmenations to expand the dataset






%Data Augmentation:
minRot = -45;
maxRot = 45; %Degrees
[I1,I2,A1,A2] = rotateAugment(I1,I2,A1,A2,minRot,maxRot); %Rotate images a random amount, 
% crop back to original size, fill edges with white. Rotation sampled
% uniformly from min to max in deg
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

shiftStdDev = 50; %in pix
[I1,I2,A1,A2] = alignmentAugment(I1,I2,A1,A2, shiftStdDev); %Shifts just the first image 
% (causing a small mis-alignment), shift amount sampled from gaussian, crop and white pad
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

shiftStdDev = 50; %in pix
[I1,I2,A1,A2] = shiftAugment(I1,I2,A1,A2, shiftStdDev); %Shifts both images together, shift 
% amount sampled from gaussian, crop and white pad
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

colourStdDev = 20; %<255
[I1,I2,A1,A2] = colourAugment(I1,I2,A1,A2, colourStdDev); %Recolour both images independently by 
% shifting the RGB channels a random amount sampled from gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

hueStdDev = 0.05; %<1
[I1,I2,A1,A2] = colourHAugment(I1,I2,A1,A2, hueStdDev); %Recolour both images independently by 
% shifting the hue channel a random amount sampled from gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

satStdDev = 0.05; %<1
[I1,I2,A1,A2] = colourSAugment(I1,I2,A1,A2, satStdDev); %Recolour both images independently by 
% shifting the saturation channel a random amount sampled from gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

valStdDev = 0.1; %<1
[I1,I2,A1,A2] = colourVAugment(I1,I2,A1,A2, valStdDev); %Recolour both images independently by 
% shifting the value channel a random amount sampled from gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

chanceFlip  = 0.5;
[I1,I2,A1,A2] = mirrorAugment(I1,I2,A1,A2, chanceFlip); %Flip both images left/right or 
% top/down. Chanceflip is bernoulli, chance of vert flip is independent of horz flip
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

scaleStdDev = 0.05;
[I1,I2,A1,A2] = scaleAugment(I1,I2,A1,A2, scaleStdDev); %Scale both images a random amount, 
% sampled from a gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

noiseStdDev = 0.005; %<1
[I1,I2,A1,A2] = noiseAugment(I1,I2,A1,A2, noiseStdDev); %Add random noise to each pixel independently 
% sampled from gaussian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

shearStdDev = 0.1;
[I1,I2,A1,A2] = shearAugment(I1,I2,A1,A2, shearStdDev); %Apply a shear operation to both images, 'a' value from 
% https://au.mathworks.com/help/images/padding-and-shearing-an-image-simultaneously.html is sampled from guassian
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

surfaceMaxHeight = 100;
showSurf = false;
warpTogether = false;
[I1,I2,A1,A2] = localwarpAugment(I1,I2,A1,A2, surfaceMaxHeight,showSurf,warpTogether); %Map the image onto a 3D surface 
% and reconstruct locally warped 2D image from this. Not sure how to do this yet.
figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);

[I1,I2,A1,A2] = removeOutsideBoxes(I1,I2,A1,A2); %Remove any annotations that fall outside the image bounds or on only white

badBoxRatio = 5;
[I1,I2,A1,A2] = removeBadRatioBoxes(I1,I2,A1,A2,badBoxRatio); %Remove any boxes where one dimension is more than ratio times the other

figure(1)
drawAnnotations(I1,A1);
figure(2);
drawAnnotations(I2,A2);